/* eslint-disable no-unused-vars */

'use strict';

var base = module.superModule;

var URLUtils = require('dw/web/URLUtils');
var Resource = require('dw/web/Resource');

/**
 * Order class that represents the current order
 * @param {dw.order.LineItemCtnr} lineItemContainer - Current users's basket/order
 * @param {Object} options - The current order's line items
 * @param {Object} options.config - Object to help configure the orderModel
 * @param {string} options.config.numberOfLineItems - helps determine the number of lineitems needed
 * @param {string} options.countryCode - the current request country code
 * @constructor
 */
function OrderModel(lineItemContainer, options) {
    var RedsysConstants = require('*/cartridge/scripts/constants/redsysConstants');

    base.apply(this, Array.prototype.slice.call(arguments));

    if (lineItemContainer.paymentInstruments.length > 0) {
        var paymentMethod = lineItemContainer.paymentInstruments[0].paymentMethod;

        if (paymentMethod === RedsysConstants.REDSYS_CREDIT_CARD) {
            this.resources.cardType = Resource.msg('msg.payment.type.credit.card', 'redsys', null);
        }

        if (paymentMethod === RedsysConstants.REDSYS_BIZUM) {
            this.resources.cardType = Resource.msg('msg.payment.type.bizum', 'redsys', null);
        }
    }
}

OrderModel.prototype = Object.create(base.prototype);
module.exports = OrderModel;
