'use strict';

var URLUtils = require('dw/web/URLUtils');

module.exports = {
    // Configuration
    REDSYS_CREDIT_CARD: 'REDSYS_CREDIT_CARD',
    REDSYS_BIZUM: 'REDSYS_BIZUM',
    REDSYS_MODE_TEST: 'Test',
    REDSYS_MODE_LIVE: 'Live',
    REDSYS_INTEGRATION_INSITE: 'InSite',
    REDSYS_INTEGRATION_REDIRECTION: 'Redirection',

    // Response variables
    REDSYS_RESPONSE_FAIL: 'fail',
    REDSYS_RESPONSE_PASS: 'pass',
    REDSYS_FRICTIONLESS: 'Frictionless',

    // Encription
    RESDSYS_DS_SIGNATURE_VERSION: 'HMAC_SHA256_V1',

    // Redirection urls
    REDSYS_REDIRECTION_URL_TEST: 'https://sis-t.redsys.es:25443/sis/realizarPago',
    REDSYS_REDIRECTION_URL_LIVE: 'https://sis.redsys.es/sis/realizarPago',

    // External scripts
    REDSYS_EXTERNAL_SCRIPT_TEST: 'https://sis-t.redsys.es:25443/sis/NC/sandbox/redsysV3.js',
    REDSYS_EXTERNAL_SCRIPT_LIVE: 'https://sis.redsys.es/sis/NC/redsysV3.js',

    // REST endpoints
    REDSYS_SERVICE_INICIA_PETICION_REST: 'iniciaPeticionREST',
    REDSYS_SERVICE_TRATA_PETICION_REST: 'trataPeticionREST',

    // EMV3DS constants
    REDSYS_EMV3DS_PROTOCOL_VERSION_102: '1.0.2',
    REDSYS_EMV3DS_PROTOCOL_VERSION_N03DS_V2: 'NO_3DS_v2',
    REDSYS_EMV3DS_CHALLENGE_REQUEST: 'ChallengeRequest',
    REDSYS_EMV3DS_CHALLENGE_REQUEST_RESPONSE: 'ChallengeResponse',
    REDSYS_MERCHANT_IDENTIFIER_REQUIRED: 'REQUIRED',
    REDSYS_INSITE_NOTIFICATION_URL: URLUtils.abs('Redsys-InSiteNotify').toString(),
    REDSYS_EMV3DS_AUTHENTICACIONDATA: 'AuthenticationData',
    REDSYS_EMV3DS_BROWSER_ACCEPT_HEADER: 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,application/json'
};
