'use strict';

var server = require('server');
server.extend(module.superModule);

var userLoggedIn = require('*/cartridge/scripts/middleware/userLoggedIn');
var consentTracking = require('*/cartridge/scripts/middleware/consentTracking');

server.append(
    'Show',
    server.middleware.https,
    userLoggedIn.validateLoggedIn,
    consentTracking.consent,
    function (req, res, next) {
        var viewData = res.getViewData();
        // Remove addPaymentUrl because Redsys only save payment instruments after order finish successfully
        viewData.addPaymentUrl = null;
        return next();
    });

module.exports = server.exports();
