'use strict';

/**
 * Save customer's browser info to inputs
 */
function saveBrowserInfo() {
    $('#javaEnabled').val(navigator.javaEnabled());
    $('#javaScriptEnabled').val(true);
    $('#userAgent').val(navigator.userAgent);
    $('#browserLanguage').val(navigator.language);
    $('#browserColorDepth').val(window.screen.colorDepth);
    $('#browserScreenHeight').val(window.screen.height);
    $('#browserScreenWidth').val(window.screen.width);
    $('#browserTZ').val((new Date()).getTimezoneOffset());
}

/**
 * Get active payment method
 * @returns {string} Payment method id
 */
function getPaymentMethodId() {
    return $('.payment-information').attr('data-payment-method-id');
}

/**
 * Set active payment method
 * @param {Object} paymentMethod - checkout model to use as basis of new truth
 */
function setPaymentMethodId(paymentMethod) {
    $('.payment-information').attr('data-payment-method-id', paymentMethod);
}

/**
 * Render Redsys credit card iframe and customize iframe styles inline
 */
function renderRedsysInSiteForm() {
    var url = $('#redsysInSiteGetData').val();
    $.spinner().start();
    $.ajax({
        url: url,
        type: 'GET',
        success: function (response) {
            var formInsiteData = response.inSiteData;
            // Function from external Redsys file
            // eslint-disable-next-line no-undef
            getInSiteForm(
                'redsysInSite',
                'background-color:#00a1e0;color:#fff;opacity:1',
                '',
                '',
                '',
                $('.submit-payment').text().trim(),
                formInsiteData.fuc,
                formInsiteData.terminal,
                formInsiteData.orderNo,
                formInsiteData.language,
                false
            );
        }
    });
    $.spinner().stop();
}

module.exports = {
    saveBrowserInfo: saveBrowserInfo,
    getPaymentMethodId: getPaymentMethodId,
    setPaymentMethodId: setPaymentMethodId,
    renderRedsysInSiteForm: renderRedsysInSiteForm
};
