<?php
defined('_JEXEC') or die('Restricted access');
/**
 * Bizum installation script file
 *
 * @author Bizum
 * @package Bizum
 */
// hack to prevent defining these twice in 1.6 installation
if (!defined('_VM_SCRIPT_INCLUDED')) {
	define('_VM_SCRIPT_INCLUDED', true);
	class com_virtuemart_allinoneInstallerScript {
		public function preflight(){
			//$this->vmInstall();
		}
		public function install(){
			//$this->vmInstall();
		}
		public function discover_install(){
			//$this->vmInstall();
		}
		public function postflight () {
			$this->vmInstall();
		}
		public function vmInstall () {
			
			$this->createIndexFolder(JPATH_ROOT .'/plugins/vmpayment');
			$this->path = JInstaller::getInstance()->getPath('extension_administrator');
			$this->installPlugin('VM Payment - Bizum', 'plugin', 'bizum', 'vmpayment');
			// language auto move
			$src= $this->path ;
			$dst= JPATH_ADMINISTRATOR . "/language" ;
			$this->recurse_copy( $src ,$dst );
			return true;
		}
		
		/**
		 * Installs a vm plugin into the database
		 *
		 */
		private function installPlugin($name, $type, $element, $group){
			$data = array();
			if(version_compare(JVERSION,'1.7.0','ge')) {
				// Joomla! 1.7 code here
				$table = JTable::getInstance('extension');
				$data['enabled'] = 1;
				$data['access']  = 1;
				$tableName = '#__extensions';
				$idfield = 'extension_id';
			} elseif(version_compare(JVERSION,'1.6.0','ge')) {
				// Joomla! 1.6 code here
				$table = JTable::getInstance('extension');
				$data['enabled'] = 1;
				$data['access']  = 1;
				$tableName = '#__extensions';
				$idfield = 'extension_id';
			} else {
				// Joomla! 1.5 code here
				$table = JTable::getInstance('plugin');
				$data['published'] = 1;
				$data['access']  = 0;
				$tableName = '#__plugins';
				$idfield = 'id';
			}
			$data['name'] = $name;
			$data['type'] = $type;
			$data['element'] = $element;
			$data['folder'] = $group;
			$data['client_id'] = 0;
			$src= $this->path .'/plugins/'. $group ."/".$element;
			if(version_compare(JVERSION,'1.6.0','ge')) {
				$data['manifest_cache'] = json_encode(JApplicationHelper::parseXMLInstallFile($src."/".$element.'.xml'));
			}
			$db = JFactory::getDBO();
			$q = 'SELECT '.$idfield.' FROM `'.$tableName.'` WHERE `name` = "'.$name.'" ';
			$db->setQuery($q);
			$count = $db->loadResult();
			if(!empty($count)){
				$table->load($count);
			}
			if(!$table->bind($data)){
				$app = JFactory::getApplication();
				$app -> enqueueMessage('VMInstaller table->bind throws error for '.$name.' '.$type.' '.$element.' '.$group);
			}
			if(!$table->check($data)){
				$app = JFactory::getApplication();
				$app -> enqueueMessage('VMInstaller table->check throws error for '.$name.' '.$type.' '.$element.' '.$group);
			}
			if(!$table->store($data)){
				$app = JFactory::getApplication();
				$app -> enqueueMessage('VMInstaller table->store throws error for '.$name.' '.$type.' '.$element.' '.$group);
			}
			$errors = $table->getErrors();
			foreach($errors as $error){
				$app = JFactory::getApplication();
				$app -> enqueueMessage( get_class( $this ).'::store '.$error);
			}
			if(version_compare(JVERSION,'1.7.0','ge')) {
				// Joomla! 1.7 code here
				$dst= JPATH_ROOT . '/plugins/' . $group."/".$element;
			} elseif(version_compare(JVERSION,'1.6.0','ge')) {
				// Joomla! 1.6 code here
				$dst= JPATH_ROOT . '/plugins/' . $group."/".$element;
			} else {
				// Joomla! 1.5 code here
				$dst= JPATH_ROOT . '/plugins/' . $group;
			}
			$this->recurse_copy( $src ,$dst );
			$this->move_logo( $dst );
		}
		
		private function move_logo($src){
			$dst=JPATH_ROOT."/images/stories/virtuemart/payment";
			$file="Bizum.png";
		
			if(!JFile::move($src ."/". $file,$dst ."/". $file)){
				$app = JFactory::getApplication();
				$app -> enqueueMessage('Couldnt move '.$src ."/". $file.' to '.$dst ."/". $file);
			}
		}
		
		/**
		 * copy all $src to $dst folder and remove it
		 * Enter description here ...
		 * @param String $src path
		 * @param String $dst path
		 * @param String $type modules, plugins, languageBE, languageFE
		 */
		private function recurse_copy($src,$dst ) {
			$dir = opendir($src);
			@mkdir($dst);
			if(is_resource($dir)){
				while(false !== ( $file = readdir($dir)) ) {
					if (( $file != '.' ) && ( $file != '..' )) {
						if ( is_dir($src ."/". $file) ) {
							$this->recurse_copy($src ."/". $file,$dst ."/". $file);
						}
						else {
							if(!JFile::move($src ."/". $file,$dst ."/". $file)){
								$app = JFactory::getApplication();
								$app -> enqueueMessage('Couldnt move '.$src ."/". $file.' to '.$dst ."/". $file);
							}
						}
					}
				}
				closedir($dir);
				//if (is_dir($src)) $this->RemoveDir($src, true);
				//if (is_dir($src)) JFolder::delete($src);
			} else {
				$app = JFactory::getApplication();
				$app -> enqueueMessage('Couldnt read dir '.$dir.' source '.$src);
			}
		}
		public function uninstall() {
			return true;
		}
		
		/**
		 * creates a folder with empty html file
		 *
		 */
		public function createIndexFolder($path){
			if(JFolder::create($path)) {
				JFile::copy(JPATH_ROOT.'/components/index.html', $path . '/index.html');
			}
		}
	}
	
	function com_install(){
		if(!version_compare(JVERSION,'1.6.0','ge')) {
			$vmInstall = new com_virtuemart_allinoneInstallerScript();
			$vmInstall->vmInstall();
		}
		return true;
	}
	function com_uninstall(){
		return true;
	}
}