<?php

/**
* NOTA SOBRE LA LICENCIA DE USO DEL SOFTWARE
* 
* El uso de este software estÃ¡ sujeto a las Condiciones de uso de software que
* se incluyen en el paquete en el documento "Aviso Legal.pdf". TambiÃ©n puede
* obtener una copia en la siguiente url:
* http://www.redsys.es/wps/portal/redsys/publica/areadeserviciosweb/descargaDeDocumentacionYEjecutables
* 
* Redsys es titular de todos los derechos de propiedad intelectual e industrial
* del software.
* 
* Quedan expresamente prohibidas la reproducciÃ³n, la distribuciÃ³n y la
* comunicaciÃ³n pÃºblica, incluida su modalidad de puesta a disposiciÃ³n con fines
* distintos a los descritos en las Condiciones de uso.
* 
* Redsys se reserva la posibilidad de ejercer las acciones legales que le
* correspondan para hacer valer sus derechos frente a cualquier infracciÃ³n de
* los derechos de propiedad intelectual y/o industrial.
* 
* Redsys Servicios de Procesamiento, S.L., CIF B85955367
*/

defined ('_JEXEC') or die('Restricted access');

if(!function_exists("escribirLog")) {
	require_once('apiRedsys/redsysLibrary.php');
}
if(!class_exists("RedsysAPI")) {
	require_once('apiRedsys/apiRedsysFinal.php');
}

/**
 * @version: Bizum 3.0.1
 */
if (!class_exists ('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

	class plgVmPaymentBizum extends vmPSPlugin {

	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);
		
		$this->_loggable = TRUE;

		$this->tableFields = array_keys ($this->getTableSQLFields ());
		$this->_tablepkey = 'id';
		$this->_tableId = 'id';
		$varsToPush = $this->getVarsToPush ();
		$this->setConfigParameterable ($this->_configTableFieldName, $varsToPush);

	}

	/**
	 * Create the table for this plugin if it does not yet exist.
	 *
	 *
	 */
	public function getVmPluginCreateTableSQL () {

		return $this->createTableSQL ('Payment Bizum Table');
	}

	/**
	 * Fields to create the payment table
	 *
	 * @return string SQL Fileds
	 */
	function getTableSQLFields () {

		$SQLfields = array(
			'id'                          => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'         => 'int(1) UNSIGNED',
			'order_number'                => 'char(64)',
			'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
			'payment_name'                => 'varchar(5000)',
			'payment_order_total'         => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'            => 'char(3)',
			'email_currency'              => 'char(3)',
			'cost_per_transaction'        => 'decimal(10,2)',
			'cost_percent_total'          => 'decimal(10,2)',
			'tax_id'                      => 'smallint(1)'
		);

		return $SQLfields;
	}

	/**
	 *
	 *
	 * Se genera el formulario de envÃ­o al SIS
	 */
	function plgVmConfirmedOrder ($cart, $order) {
		// Version
		$merchantModule = 'virtuemart_3.0.1';
		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL;
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}

		$lang = JFactory::getLanguage ();
		$filename = 'com_virtuemart';
		$lang->load ($filename, JPATH_ADMINISTRATOR);

		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		if (!class_exists ('VirtueMartModelCurrency')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
		}
		$currency = CurrencyDisplay::getInstance ('', $order['details']['BT']->virtuemart_vendor_id);
		
		$totalcompra = floatval($order['details']['BT']->order_total);

		//Precio del pedido
		$transaction_amount = number_format((float)($order['details']['BT']->order_total), 2, '.', '' );
		$transaction_amount = str_replace('.','',$transaction_amount);
		$transaction_amount = floatval($transaction_amount);
		
		//Num. Pedido
		$num_pedido=$order['details']['BT']->order_number;
		
		//Productos del pedido
		foreach ($cart->products as $pkey => $product) {
			$productos .= $product->quantity.'x'.$product->product_name.'/';
		}
		
		//Moneda de pago
		$monedaISO=$method->bizum_moneda;
		if($monedaISO=="0"){
			$monedaISO="978";
		}
		else{
			$monedaISO="840";
		}
		
		//Idioma
		$idiomaFinal=$method->bizum_idiomas;
		if($idiomaFinal=="0"){}
		else {
			$idioma_web = substr($_SERVER["HTTP_ACCEPT_LANGUAGE"],0,2); 
			switch ($idioma_web) {
				case 'es':
				$idiomaFinal='001';
				break;
				case 'en':
				$idiomaFinal='002';
				break;
				case 'ca':
				$idiomaFinal='003';
				break;
				case 'fr':
				$idiomaFinal='004';
				break;
				case 'de':
				$idiomaFinal='005';
				break;
				case 'nl':
				$idiomaFinal='006';
				break;
				case 'it':
				$idiomaFinal='007';
				break;
				case 'sv':
				$idiomaFinal='008';
				break;
				case 'pt':
				$idiomaFinal='009';
				break;
				case 'pl':
				$idiomaFinal='011';
				break;
				case 'gl':
				$idiomaFinal='012';
				break;
				case 'eu':
				$idiomaFinal='013';
				break;
				default:
				$idiomaFinal='002';
			}		
		}
	
		//Url Respuesta Online
		$urltienda = JURI::root () . 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&on=' .
			                        $order['details']['BT']->order_number .
			                        '&pm=' .
			                        $order['details']['BT']->virtuemart_paymentmethod_id .
		                            '&Itemid=' . JRequest::getInt ('Itemid') .
								    '&lang='.JRequest::getCmd('lang','');
		
		$cantidad = $transaction_amount;
		$moneda = $monedaISO;
		$numpedido = $num_pedido;
		$codigo = $method->bizum_fuc;
		$terminal = $method->bizum_terminal;
		$trans = $method->bizum_trans;
		$ds_merchant_titular = $order['details']['BT']->first_name." ".$order['details']['BT']->last_name;
		$ds_merchant_name = $method->bizum_nombre;
		$ds_merchant_data = sha1($urltienda);
		$ds_merchant_urlok = $urltienda;
		$ds_merchant_urlko = $urltienda;
		$idioma_tpv = $idiomaFinal;
		$paymethods = 'z';
		
		//Se recogen las variables del formulario de config. para el SIS
		$miObj = new RedsysAPI;
		$miObj->setParameter("DS_MERCHANT_AMOUNT",$cantidad);
		$miObj->setParameter("DS_MERCHANT_ORDER",strval($numpedido));
		$miObj->setParameter("DS_MERCHANT_MERCHANTCODE",$codigo);
		$miObj->setParameter("DS_MERCHANT_CURRENCY",$moneda);
		$miObj->setParameter("DS_MERCHANT_TRANSACTIONTYPE",$trans);
		$miObj->setParameter("DS_MERCHANT_TERMINAL",$terminal);
		$miObj->setParameter("DS_MERCHANT_MERCHANTURL",$urltienda);
		$miObj->setParameter("DS_MERCHANT_URLOK",$ds_merchant_urlok);
		$miObj->setParameter("DS_MERCHANT_URLKO",$ds_merchant_urlko);
		$miObj->setParameter("Ds_Merchant_ConsumerLanguage",$idioma_tpv);
		$miObj->setParameter("Ds_Merchant_ProductDescription",$productos);
		$miObj->setParameter("Ds_Merchant_Titular",$ds_merchant_titular);
		$miObj->setParameter("Ds_Merchant_MerchantData",$ds_merchant_data);
		$miObj->setParameter("Ds_Merchant_MerchantName",$ds_merchant_name);
		$miObj->setParameter("Ds_Merchant_PayMethods", $paymethods);
		$miObj->setParameter("Ds_Merchant_Module","virtuemart_bizum_3.0.1");

		//Datos de configuraciÃ³n
		$version = getVersionClave();
		
		//Clave del comercio que se extrae de la configuraciÃ³n del comercio
		// Se generan los parÃ¡metros de la peticiÃ³n
		$request = "";
		$paramsBase64 = $miObj->createMerchantParameters();
		$signatureMac = $miObj->createMerchantSignature($method->bizum_clave256);
		
		//Entorno de trabajo
		$entorno = $method->bizum_entorno;
		if ($entorno == '3') {
			$entorno = 'https://sis.redsys.es/sis/realizarPago/utf-8';
		} else if ($entorno == '0') {
			$entorno = 'http://sis-d.redsys.es/sis/realizarPago/utf-8';
		} else if ($entorno == '1') {
			$entorno = 'https://sis-i.redsys.es:25443/sis/realizarPago/utf-8';
		} else {
			$entorno = 'https://sis-t.redsys.es:25443/sis/realizarPago/utf-8';
		}	
  
		//Generamos cÃƒÂ³digo HTML para el formulario de envÃ­o al SIS
		$html = '<html><head><title>Redirection</title></head><body><div style="margin: auto; text-align: center;">';
		$html .= '<form action="'.$entorno.'" method="post" name="vm_bizum_form">';

		$html .= '<input type="hidden" name="Ds_SignatureVersion" value="' . $version . '" />';
		$html .= '<input type="hidden" name="Ds_MerchantParameters" value="' . $paramsBase64 . '" />';
		$html .= '<input type="hidden" name="Ds_Signature" value="' . $signatureMac . '" />';

		$html .= '<input type="submit"  value="Si no redirige automÃ¡ticamente a la autenticaciÃƒÂ³n Bizum, pulse aquÃ­." />
					<script type="text/javascript" data-cfasync="false">';
		$html .= '		document.vm_bizum_form.submit();';
		$html .= '	</script>';
		$html .= '</form></div>';
		$html .= '</body></html>';

		//Se crea el pedido
		$modelOrder = VmModel::getModel ('orders');
		//Status del pedido -> "Pending"
		$order['order_status'] = $this->getNewStatus ($method);
		$order['customer_notified'] = 1;
		$order['comments'] = '';
		$modelOrder->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, TRUE);

		JRequest::setVar ('html', $html);
		return TRUE;

	}

	/*
		 * 
		 * Se genera el status inicial del pedido -> "Pending"
		 */
	function getNewStatus ($method) {
		vmInfo (JText::_ ('BIZUM: Pedido en estado "Pending"'));
		if (isset($method->status_pending) and $method->status_pending!="") {
			return $method->status_pending;
		} else {
			// $StatutWhiteList = array('P','C','X','R','S','N');
			return 'P';  //PENDING
			//return 'X';  //CANCELLED
			//return 'R';  //REFUNDED
			//return 'C';  //CONFIRMED
		}
	}

		/**
	 * @param $html
	 * @return bool|null|string
	 */
	function plgVmOnPaymentResponseReceived (&$html) {
		
		if (!class_exists('VirtueMartCart')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		if (!class_exists('shopFunctionsF')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}
		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}

		// Recuperamos Identificador de pedido
		$virtuemart_paymentmethod_id = JRequest::getInt('pm', 0);
		$order_number = JRequest::getString('on', 0);
		
		if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
			return NULL; 
		}
		
		if (!$this->selectedThisElement($method->payment_element)) {
			return NULL;
		}
		
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
			return NULL;
		}
		
		$idLog = generateIdLog(); 
		$logActivo = $method->bizum_log;
		$mantener_pedido_ante_error = $method->bizum_error_pago;
		// Recogemos la clave del comercio para autenticar
		$clave256=$method->bizum_clave256;
		$estado=$method->bizum_estado;
		
		escribirLog($idLog." -- ".'NotificaciÃ³n del pedido '.$virtuemart_order_id.' ',$logActivo);
		
		if (!empty( $_POST ) ) {//URL DE RESP. ONLINE

			/** Recoger datos de respuesta **/
			$version     = $_POST["Ds_SignatureVersion"];
			$datos    = $_POST["Ds_MerchantParameters"];
			$firma_remota    = $_POST["Ds_Signature"];

			// Se crea Objeto
			$miObj = new RedsysAPI;
	
			/** Se decodifican los datos enviados y se carga el array de datos **/
			$decodec = $miObj->decodeMerchantParameters($datos);

			/** Se calcula la firma **/
			$firma_local = $miObj->createMerchantSignatureNotif($clave256,$datos);	
	
			/** Extraer datos de la notificaciÃ³n **/
			$total      = $miObj->getParameter('Ds_Amount');
			$pedido     = $miObj->getParameter('Ds_Order');
			$codigo     = $miObj->getParameter('Ds_MerchantCode');
			$moneda     = $miObj->getParameter('Ds_Currency');
			$respuesta  = $miObj->getParameter('Ds_Response');
			$id_trans   = $miObj->getParameter('Ds_AuthorisationCode');
			$fecha= $miObj->getParameter('Ds_Date');
			$hora= $miObj->getParameter('Ds_Hour');
			
			$codigoOrig = $method->bizum_fuc;
			
			/** VALIDACIONES DE LIBRERÃ�A **/
			if ($firma_local === $firma_remota
				&& checkImporte($total)
				&& checkFuc($codigo)
				&& checkMoneda($moneda)
				&& checkRespuesta($respuesta)
				&& $codigoOrig == $codigo
				) {

					$respuesta = intval($respuesta);
					
					if ($respuesta < 101 && checkAutCode($id_trans)) {
						escribirLog($idLog." -- ".'Pedido '.$virtuemart_order_id.' finalizado correctamente ',$logActivo);
						$orderModel = VmModel::getModel('orders');
						$order = $orderModel->getOrder($virtuemart_order_id);
						$order['order_status'] =  $estado;
						$order['customer_notified'] = 1;
						$orderModel->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, TRUE);
						//Se eliminan productos del carrito
						$cart = VirtueMartCart::getCart();
						$cart->emptyCart();
					}
					else {
						escribirLog($idLog." -- ".'Pedido '.$virtuemart_order_id.' finalizado con errores en la respuesta ',$logActivo);
						$orderModel = VmModel::getModel('orders');
						if($mantener_pedido_ante_error != 'si') {
							$order = $orderModel->getOrder($virtuemart_order_id);
							$order['order_status'] =  "X";
							$order['customer_notified'] = 1;
							$cart = VirtueMartCart::getCart();
							$cart->emptyCart();
						}
						$orderModel->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, TRUE);
					}
				}// if (firma_local=firma_remota)
				else {
						escribirLog($idLog." -- ".'Pedido '.$virtuemart_order_id.' finalizado con error de firma ',$logActivo);
						$orderModel = VmModel::getModel('orders');
						$order = $orderModel->getOrder($virtuemart_order_id);
						$order['order_status'] =  "X";
						$order['customer_notified'] = 1;
						$orderModel->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, TRUE);
						$cart = VirtueMartCart::getCart();
						$cart->emptyCart();
				}		
		}
		else {//URL OK Y KO

			/** Recoger datos de respuesta **/
			$version     = $_GET["Ds_SignatureVersion"];
			$datos    = $_GET["Ds_MerchantParameters"];
			$firma_remota    = $_GET["Ds_Signature"];

			// Se crea Objeto
			$miObj = new RedsysAPI;
	
			/** Se decodifican los datos enviados y se carga el array de datos **/
			$decodec = $miObj->decodeMerchantParameters($datos);

			/** Se calcula la firma **/
			$firma_local = $miObj->createMerchantSignatureNotif($clave256,$datos);
	
			/** Extraer datos de la notificaciÃ³n **/
			$total      = $miObj->getParameter('Ds_Amount');
			$pedido     = $miObj->getParameter('Ds_Order');
			$codigo     = $miObj->getParameter('Ds_MerchantCode');
			$moneda     = $miObj->getParameter('Ds_Currency');
			$respuesta  = $miObj->getParameter('Ds_Response');
			$id_trans   = $miObj->getParameter('Ds_AuthorisationCode');
			$fecha= $miObj->getParameter('Ds_Date');
			$hora= $miObj->getParameter('Ds_Hour');
			
			$codigoOrig = $method->bizum_fuc;
			
			/** VALIDACIONES DE LIBRERÃ�A **/
			if ($firma_local === $firma_remota
				&& checkImporte($total)
				&& checkFuc($codigo)
				&& checkMoneda($moneda)
				&& checkRespuesta($respuesta)
				&& $codigoOrig == $codigo
				) {
					$respuesta = intval($respuesta);
					if ($respuesta < 101 && checkAutCode($id_trans)) {
						escribirLog($idLog." -- ".'Pedido '.$virtuemart_order_id.' finalizado correctamente',$logActivo);
						$html = '<img src="'.JURI::root () .'plugins/vmpayment/bizum/bizum/assets/images/Bizum.png"><br><br><br>';
						$html .= '<h2><img src="'.JURI::root () .'plugins/vmpayment/bizum/bizum/assets/images/success.png">  El pedido con referencia '.$pedido.' ha finalizado correctamente. Gracias por utilizar Bizum.</h2>';
						//Se eliminan productos del carrito
						$cart = VirtueMartCart::getCart();
						$cart->emptyCart();
					}
					else {
						escribirLog($idLog." -- ".'Pedido '.$virtuemart_order_id.' finalizado con error en la respuesta ',$logActivo);
						$html = '<img src="'.JURI::root () .'plugins/vmpayment/redsys/redsys/assets/images/Redsys.png"><br><br><br>';
						$html .= '<h2><img src="'.JURI::root () .'plugins/vmpayment/redsys/redsys/assets/images/cross.png">  El pedido con referencia '.$pedido.' ha finalizado con error en la respuesta. Gracias por utilizar Redsys.</h2>';
						if($mantener_pedido_ante_error == 'si') {
							$html .= '<h3>Su carrito no se ha borrado, puede reintentar su compra.</h3>';
						} else {
							$cart = VirtueMartCart::getCart();
							$cart->emptyCart();
						}
					}
				}// if (firma_local=firma_remota)
				else {
						vmError(JText::_ ('bizum:  Pedido '.$virtuemart_order_id.' finalizado con error de firma '));
						$html = '<img src="'.JURI::root () .'plugins/vmpayment/bizum/bizum/assets/images/Bizum.png"><br><br><br>';
						$html .= '<h2><img src="'.JURI::root () .'plugins/vmpayment/bizum/bizum/assets/images/cross.png">  El pedido con referencia '.$pedido.' ha finalizado con error de firma. Gracias por utilizar Bizum.</h2>';
						$html .= '<h3>Su carrito no se ha borrado, puede reintentar su compra.</h3>';
					}	
		}	
		return TRUE;
	}
	
	
	
	
	//*****************************************************************************************
	
	
	/**
	 * Display stored payment data for an order
	 *
	 */
	function plgVmOnShowOrderBEPayment ($virtuemart_order_id, $virtuemart_payment_id) {

		if (!$this->selectedThisByMethodId ($virtuemart_payment_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}
		VmConfig::loadJLang('com_virtuemart');

		$html = '<table class="adminlist table">' . "\n";
		$html .= $this->getHtmlHeaderBE ();
		$html .= $this->getHtmlRowBE ('COM_VIRTUEMART_PAYMENT_NAME', $paymentTable->payment_name);
		$html .= $this->getHtmlRowBE ('BIZUM_PAYMENT_TOTAL_CURRENCY', $paymentTable->payment_order_total . ' ' . $paymentTable->payment_currency);
		if ($paymentTable->email_currency) {
			$html .= $this->getHtmlRowBE ('BIZUM_EMAIL_CURRENCY', $paymentTable->email_currency );
		}
		$html .= '</table>' . "\n";
		return $html;
	}

	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 *
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices) {

		$this->convert_condition_amount($method);
		$amount = $this->getCartAmount($cart_prices);
		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

 		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));
		if (!$amount_cond) {
			return FALSE;
		}
		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array ($method->countries)) {
				$countries[0] = $method->countries;
			} else {
				$countries = $method->countries;
			}
		}

		// probably did not gave his BT:ST address
		if (!is_array ($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (count ($countries) == 0 || in_array ($address['virtuemart_country_id'], $countries) ) {
			return TRUE;
		}

		return FALSE;
	}


	/*
	* We must reimplement this triggers for joomla 1.7
	*/

	/**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the bizum method to create the tables
	 *
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {

		return $this->onStoreInstallPluginTable ($jplugin_id);
	}

	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not valid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart, &$msg) {

		return $this->OnSelectCheck ($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE ($cart, $selected, $htmlIn);
	}

	/*
	* plgVmonSelectedCalculatePricePayment
	* Calculate the price (value, tax_id) of the selected method
	* It is called by the calculator
	*
	*/

	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}

	function plgVmgetPaymentCurrency ($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		$this->getPaymentCurrency ($method);

		$paymentCurrencyId = $method->payment_currency;
		return;
	}

	/**
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected ($cart, $cart_prices, $paymentCounter);
	}

	/**
	 * This method is fired when showing the order details in the frontend.
	 * It displays the method-specific data.
	 *
	 * @param integer $order_id The order ID
	 * @return mixed Null for methods that aren't active, text (HTML) otherwise
	 */
	public function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {

		$this->onShowOrderFE ($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
	}
	/**
	 * @param $orderDetails
	 * @param $data
	 * @return null
	 */

	function plgVmOnUserInvoice ($orderDetails, &$data) {

		if (!($method = $this->getVmPluginMethod ($orderDetails['virtuemart_paymentmethod_id']))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return NULL;
		}
		//vmdebug('plgVmOnUserInvoice',$orderDetails, $method);

		if (!isset($method->send_invoice_on_order_null) or $method->send_invoice_on_order_null==1 or $orderDetails['order_total'] > 0.00){
			return NULL;
		}

		if ($orderDetails['order_salesPrice']==0.00) {
			$data['invoice_number'] = 'reservedByPayment_' . $orderDetails['order_number']; // Nerver send the invoice via email
		}

	}
		/**
		 * @param $virtuemart_paymentmethod_id
		 * @param $paymentCurrencyId
		 * @return bool|null
		 */
		function plgVmgetEmailCurrency($virtuemart_paymentmethod_id, $virtuemart_order_id, &$emailCurrencyId) {

			if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
				return NULL; // Another method was selected, do nothing
			}
			if (!$this->selectedThisElement($method->payment_element)) {
				return FALSE;
			}
			if (!($payments = $this->getDatasByOrderId($virtuemart_order_id))) {
				// JError::raiseWarning(500, $db->getErrorMsg());
				return '';
			}
			if (empty($payments[0]->email_currency)) {
				$vendorId = 1; //VirtueMartModelVendor::getLoggedVendor();
				$db = JFactory::getDBO();
				$q = 'SELECT   `vendor_currency` FROM `#__virtuemart_vendors` WHERE `virtuemart_vendor_id`=' . $vendorId;
				$db->setQuery($q);
				$emailCurrencyId = $db->loadResult();
			} else {
				$emailCurrencyId = $payments[0]->email_currency;
			}

		}
	/**
	 * This event is fired during the checkout process. It can be used to validate the
	 * method data as entered by the user.
	 *
	 * @return boolean True when the data was valid, false otherwise. If the plugin is not activated, it should return null.
	 *

	public function plgVmOnCheckoutCheckDataPayment(  VirtueMartCart $cart) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing when priting an Order
	 * It displays the the payment method-specific data.
	 *
	 * @param integer $_virtuemart_order_id The order ID
	 * @param integer $method_id  method used for this order
	 * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
	 *
	 */
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {

		return $this->onShowOrderPrint ($order_number, $method_id);
	}

	function plgVmDeclarePluginParamsPaymentVM3( &$data) {
		return $this->declarePluginParams('payment', $data);
	}
	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table) {

		return $this->setOnTablePluginParams ($name, $id, $table);
	}
}

// No closing tag
