package es.redsys.rest.test.example;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

import es.redsys.rest.api.constants.RestConstants;
import es.redsys.rest.api.constants.RestConstants.Environment;
import es.redsys.rest.api.constants.RestConstants.Operation;
import es.redsys.rest.api.constants.RestConstants.TransactionType;
import es.redsys.rest.api.model.RestResponse;
import es.redsys.rest.api.model.element.RestOperationElement;
import es.redsys.rest.api.model.message.RestAuthenticationRequestMessage;
import es.redsys.rest.api.model.message.RestInitialRequestMessage;
import es.redsys.rest.api.model.message.RestOperationMessage;
import es.redsys.rest.api.model.message.RestResponseMessage;
import es.redsys.rest.api.service.RestService;
import es.redsys.rest.api.service.impl.RestAuthenticationRequestService;
import es.redsys.rest.api.service.impl.RestInitialRequestService;
import es.redsys.rest.api.service.impl.RestOperationService;

/** 
 * Los ejemplos proporcionados en el API son una representación de como utilizar 
 * las diferentes funciones del API y no se deben utilizar tal cual se proporcionan,
 * ya que no contienen validaciones de seguridad y de negocio propias de la 
 * implementación de cada comercio. Redsys no se hace responsable de la utilización
 * de estos ejemplos en el servidor del comercio tal cual se proporcionan. 
 * 
 * 
 * The examples provided in the API are a representation of how to use
 * the different API functions and should not be used as provided,
 * since they do not contain security and business validations typical of the
 * implementation of each trade. Redsys is not responsible for the use
 * of these examples on the merchant's server as provided.
 */

/**
 * Example Class for testing purposes
 * @author Redsys
 */

public class Example3DSecureV2Reference {
		
	/**
	 * Method for random order number
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		public static String randomOrderID() {
			StringBuilder orderID = new StringBuilder();
			for(int i = 0 ; i < 10 ; ++i) {
				orderID.append(ALPHA_NUMERIC_STRING.charAt(ThreadLocalRandom.current().nextInt(ALPHA_NUMERIC_STRING.length())));
			}
		return orderID.toString();
	}
				
	/**
	 * Main method for testing purposes
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	public static void main(String [] args) throws IOException {
		String orderID=randomOrderID();
		inititalOperationV2(orderID);
	}

	
	/**
	 * Method for a initial operation request that gives the card protocolVersion
	 */
	private static void inititalOperationV2(String orderID) {
		
		String protocolVersion = "";
		String threeDSServerTransID = "";
		String threeDSMethodURL = "";
		
		RestInitialRequestMessage cardDataInfoRequest = new RestInitialRequestMessage();
		// Operation mandatory data
		cardDataInfoRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		cardDataInfoRequest.setCurrency("978"); // ISO-4217 numeric currency code
		cardDataInfoRequest.setMerchant("999008881");
		cardDataInfoRequest.setTerminal("20");
		cardDataInfoRequest.setOrder(orderID);
		cardDataInfoRequest.useReference("72019565bd64fc073f3bd1a241252e90426a8023");
		cardDataInfoRequest.setTransactionType(TransactionType.AUTHORIZATION);
		
		// Other optional parameters example can be added by "addParameter" method
		cardDataInfoRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago InSite con 3DSecureV2");
		
		//Method to ask about card information data
		cardDataInfoRequest.demandCardData();
		
		// Response object for the Initial Request
		RestResponse response = null;
		try {
			// Service setting (Signature and Environment)
			RestService service = new RestInitialRequestService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
			//Send the operation and catch the response
			response = service.sendOperation(cardDataInfoRequest);
			// Response analysis
			System.out.println(response.toString());
			//Method the gives the request Result (OK/KO/AUT)
			switch (response.getResult()) {
				case OK:
					//In this case the operation was ok and PSD2= "N", so authentication is not needed but its possible to make authentication
					System.out.println("Operation was OK");
					//In this case the commerce can choose which kind of operation want to use
					//directPaymentOperation (example of this operation in InsiteExampleDirectPayment.java)
					//or authenticationOperation (recommended)
					authenticationOperation(orderID, protocolVersion, threeDSServerTransID, threeDSMethodURL);
				break;
				case AUT: 
					//In this case the operation was ok and PSD2= "Y" and return the protocolVersion parameter
					System.out.println("Operation requires authentication"); 
					//Method to catch the threeDSInfo value
					String threeDSInfo = response.getThreeDSInfo();
					//Method to catch the protocolVersion (Required for authentication Request)
					protocolVersion = response.protocolVersionAnalysis();
					//Because the protocolVersion in this example is 2.X.0, its required to catch two mandatory Parameters in the response
					threeDSServerTransID = response.getThreeDSServerTransID();
					threeDSMethodURL = response.getThreeDSMethodURL();
					//Ones we catch the parameters, we must make the authenticationRequest
					authenticationOperation(orderID, protocolVersion, threeDSServerTransID, threeDSMethodURL);
				break;
				case KO: 
					System.out.println("Operation was not OK"); 
				break;
				default:
					System.out.println("Aquí no debemos entrar!!!!");
			}
		} catch (Exception e) {
			// Error treatment
			e.printStackTrace();
		}
	 }
	
	
	/**
	 * Method for a authentication operation request. This request depend on the initial request parameter "protocolVersion"
	 * @param orderID
	 * @param protocolVersion
	 * @param threeDSMethodURL 
	 * @param threeDSServerTransID 
	 */
	private static void authenticationOperation(String orderID, String protocolVersion, String threeDSServerTransID, String threeDSMethodURL) {
		
		RestOperationMessage operationRequest = new RestOperationMessage();
		
		// Operation mandatory data
		operationRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		operationRequest.setCurrency("978"); // ISO-4217 numeric currency code
		operationRequest.setMerchant("999008881");
		operationRequest.setTerminal("20");
		operationRequest.setOrder(orderID);
		operationRequest.useReference("72019565bd64fc073f3bd1a241252e90426a8023");
		operationRequest.setTransactionType(TransactionType.AUTHORIZATION);
		
		
		//To get these authenticationRequest parameters values, the commerce needs to implement the 3DSMethod Request (consult the rest connection guide)
		//Each operation has its own values for the parameters values and the commerce must catch them
		//THIS is only an example of the values. 
		
		String browserAcceptHeader = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,application/json";
		String browserUserAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36";
		String browserJavaEnable = "false";
		String browserJavaScriptEnabled = "false";
		String browserLanguage = "ES-es";
		String browserColorDepth = "24";
		String browserScreenHeight = "1250";
		String browserScreenWidth = "1320";
		String browserTZ = "52";
		//threeDSServerTransID = "8de84430-3336-4ff4-b18d-f073b546ccea";
		String notificationURL= "https://comercio-inventado.es/recibe-respuesta-autenticacion";
		String threeDSCompInd = "Y";
		
		// Other optional parameters example can be added by "addParameter" method
		operationRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago InSite con 3DSecureV2");
		
		
		//Method that can be use to add the return parameters to the authentication request for protocolVersion 2.X.0
		operationRequest.setEMV3DSParamsV2(protocolVersion, browserAcceptHeader, browserUserAgent, browserJavaEnable, browserJavaScriptEnabled, browserLanguage, browserColorDepth, browserScreenHeight, browserScreenWidth, browserTZ, threeDSServerTransID, notificationURL, threeDSCompInd);
		
		// Response object for the authenticacionRequest
		RestResponse response = null;
			try {
				// Service setting (Signature and Environment)
					RestService service = new RestOperationService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
					//Send the operation and catch the response
					response = service.sendOperation(operationRequest);
					// Response analysis
					System.out.println(response.toString());
					//Depending on the response, its nedeed to finish or to make another step
					//Method the gives the request Result (OK/KO/AUT)
					switch (response.getResult()) {
						case OK:
							//This is a frictionless response. In this case the operation was ok and the api return the final operation response
							System.out.println("Operation was OK");
						break;
						case AUT: 
							//If the operation was AUT, its a challenge response, the commerce needs to catch the authenticationParameters and send them in another Request
							//Its possible that sometimes is not possible to authenticate by V2 version,
							//so the commerce have to be prepared for get both responses
							String protocolVersionOperation = response.protocolVersionAnalysis();
							if (protocolVersionOperation.equals(RestConstants.RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_102)) {
								//If the operation was AUT, its a challenge response, the commerce needs to catch the authenticationParameters and send them in another Request
								String acsURL = response.getAcsURLParameter();
								String pAReq = response.getPAReqParameter();
								String md = response.getMDParameter();
								String termUrl = "http://www.comercio.com/authentication-response.jsp";
								//The commerce needs to send these authentication parameter (PAreq and md) by post method to AcsURL
								//In the termUrl the commerce must catch the return parameter that the AcsURL gives back
								//Once again, the commerce needs to send these catched parameters in a Request
								challengeRequestV1(orderID);
							}else {
								//The commerce needs to send the authentication parammeter (creq) by post method to AcsURL
								//Then the authenticator send the response of the authentication to the notificationURL
								String acsURL = response.getAcsURLParameter();
								String creq = response.getCreqParameter();
								//Then, in the notification url, the commerce needs to send a final request
								challengeRequestV2(orderID);		
							}
						break;
						case KO: 
							System.out.println("Operation was not OK"); 
						break;
						default:
							System.out.println("Aquí no debemos entrar!!!!");
							
					}} catch (Exception e) {
					// Error treatment
					e.printStackTrace();
				}
	
	}
	
	
	/**
	 * Method for a challenge request. This request must be done with the return authenticacion parameters
	 * that have to be catched
	 */
	private static void challengeRequestV2(String orderID) {
			//Ones the commerce capture the return authentication parameters, there is a last request to which give us the result of the operation
		    String protocolVersion = ""; //Can be 2.1.0 or 2.2.0 
			String cres = "eyJ0aHJlZURTU2VydmVyVHJhbnNJRCI6IjhkZTg0NDMwLTMzMzYtNGZmNC1iMThkLWYwNzNiNTQ2Y2NlYSIsImFjc1RyYW5zSUQiOiJkYjVjOTljNC1hMmZkLTQ3ZWUtOTI2Zi1mYTBiMDk0MzUyYTAiLCJtZXNzYWdlVHlwZSI6IkNSZXMiLCJtZXNzYWdlVmVyc2lvbiI6IjIuMS4wIiwidHJhbnNTdGF0dXMiOiJZIn0=";
			//OperationData
			RestAuthenticationRequestMessage challengeRequest = new RestAuthenticationRequestMessage();
			challengeRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
			challengeRequest.setCurrency("978"); // ISO-4217 numeric currency code
			challengeRequest.setMerchant("999008881");
			challengeRequest.setTerminal("20");
			challengeRequest.setOrder(orderID);
			challengeRequest.useReference("72019565bd64fc073f3bd1a241252e90426a8023");
			challengeRequest.setTransactionType(TransactionType.AUTHORIZATION);
			
			// Other optional parameters example can be added by "addParameter" method
			challengeRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago InSite con 3DSecureV2");
				
			//Method add the challengeRequestParameters on the protocolVersion 2.X.0
			challengeRequest.challengeRequestV2(protocolVersion, cres);
			
			// Response object for the cardData Request
			RestResponse response = null;
			try {
				// Service setting (Signature and Environment)
				RestService service = new RestAuthenticationRequestService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
				//Send the operation and catch the response
				response = service.sendOperation(challengeRequest);
				// Response analysis
				System.out.println(response.toString());
				//Method the gives the request Result (OK/KO)
				switch (response.getResult()) {
					case OK:
						System.out.println("Operation was OK");
					break;
					case KO: 
						System.out.println("Operation was not OK"); 
					break;
					default:
						System.out.println("Aquí no debemos entrar!!!!");
				}
				} catch (Exception e) {
					// Error treatment
					e.printStackTrace();
				}
	}
	
	/**
	 * Last authentication request. This request must be done with the return authenticacion parameters
	 * that have to be catched
	 */
	private static void challengeRequestV1(String orderID) {
		
			//Ones the commerce capture the return authentication parameters, there is a last request to which give us the result of the operation
			String md = "90b12ddf327ec896ac9e153d856ad4401e0241ff";
			String pares = "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";		
			
			//OperationData
			RestAuthenticationRequestMessage challengeRequest = new RestAuthenticationRequestMessage();
			challengeRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
			challengeRequest.setCurrency("978"); // ISO-4217 numeric currency code
			challengeRequest.setMerchant("999008881");
			challengeRequest.setTerminal("20");
			challengeRequest.setOrder(orderID);
			challengeRequest.useReference("72019565bd64fc073f3bd1a241252e90426a8023");
			challengeRequest.setTransactionType(TransactionType.AUTHORIZATION);
			
			// Other optional parameters example can be added by "addParameter" method
			challengeRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago InSite con 3DSecureV2");
			
			//Method add the challengeRequestParameters depends on the protocolVersion
			challengeRequest.challengeRequestV1(pares, md);

			// Response object for the cardData Request
			RestResponse response = null;
			try {
				// Service setting (Signature and Environment)
				RestService service = new RestAuthenticationRequestService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
				//Send the operation and catch the response
				response = service.sendOperation(challengeRequest);
				// Response analysis
				System.out.println(response.toString());
				//Method the gives the request Result (OK/KO)
				switch (response.getResult()) {
					case OK:
						System.out.println("Operation was OK");
					break;
					case KO: 
						System.out.println("Operation was not OK"); 
					break;
					default:
						System.out.println("Aquí no debemos entrar!!!!");
				}
				} catch (Exception e) {
					// Error treatment
					e.printStackTrace();
				}
	}	
}
