package es.redsys.rest.api.utils;

import java.io.IOException;
import java.util.Properties;
import es.redsys.rest.api.constants.RestConstants;

public class RestUtils {
	public static Properties restProperties = null; 
	public static final String getPropertyValue(final String key) {
		if (null == restProperties) {
			loadPropertiesFile();
		}
		return restProperties.getProperty(key);
	}
	
	private static final void loadPropertiesFile() {
		restProperties = new Properties();
		try {
			restProperties.load(RestUtils.class.getClassLoader().getResourceAsStream(RestConstants.APP_CONFIG_FILE));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
