package es.redsys.rest.api.constants;

import es.redsys.rest.api.utils.RestUtils;

/**
 * Constants class
 * 
 * @author Redsys
 *
 */
public class RestConstants {
	
	// Property file constant
	public static final String APP_CONFIG_FILE = "rest.properties";
	
	// Webservice constants
	public static final String HTTP_REQUEST_HEADERS_PROP_LITERAL = "javax.xml.ws.http.request.headers";
	public static final String CONNECTION_TIMEOUT_LITERAL = "javax.xml.ws.client.connectionTimeout";
	public static final String READ_TIMEOUT_LITERAL = "javax.xml.ws.client.receiveTimeout";
	public static final String HTTPS_PROTOCOLS_VARIABLE = "https.protocols";
	public static final String SSL_SOCKET_FACTORY_LITERAL = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
	
	// Request message constants
	public static final String REQUEST_SIGNATURE = "DS_SIGNATURE";
	public static final String REQUEST_SIGNATUREVERSION_VALUE = "HMAC_SHA256_V1";
	public static final String REQUEST_MERCHANT_ORDER = "DS_MERCHANT_ORDER";
	public static final String REQUEST_MERCHANT_MERCHANTCODE = "DS_MERCHANT_MERCHANTCODE";
	public static final String REQUEST_MERCHANT_TERMINAL = "DS_MERCHANT_TERMINAL";
	public static final String REQUEST_MERCHANT_TRANSACTIONTYPE = "DS_MERCHANT_TRANSACTIONTYPE";
	public static final String REQUEST_MERCHANT_IDOPER = "DS_MERCHANT_IDOPER";
	public static final String REQUEST_MERCHANT_CURRENCY = "DS_MERCHANT_CURRENCY";
	public static final String REQUEST_MERCHANT_AMOUNT = "DS_MERCHANT_AMOUNT";
	public static final String REQUEST_MERCHANT_IDENTIFIER = "DS_MERCHANT_IDENTIFIER";
	public static final String REQUEST_MERCHANT_IDENTIFIER_REQUIRED = "REQUIRED";
	public static final String REQUEST_MERCHANT_DIRECTPAYMENT = "DS_MERCHANT_DIRECTPAYMENT";
	public static final String REQUEST_MERCHANT_DIRECTPAYMENT_TRUE = "true";
	public static final String REQUEST_MERCHANT_DIRECTPAYMENT_MOTO = "MOTO";
	public static final String REQUEST_MERCHANT_CVV2 = "DS_MERCHANT_CVV2";
	public static final String REQUEST_MERCHANT_PAN = "DS_MERCHANT_PAN";
	public static final String REQUEST_MERCHANT_EXPIRYDATE = "DS_MERCHANT_EXPIRYDATE";
	public static final String REQUEST_MERCHANT_COF_INI = "DS_MERCHANT_COF_INI";
	public static final String REQUEST_MERCHANT_COF_INI_TRUE = "S";
	public static final String REQUEST_MERCHANT_COF_TYPE = "DS_MERCHANT_COF_TYPE";
	public static final String REQUEST_MERCHANT_COF_TYPE_INSTALLMENTS = "I";
	public static final String REQUEST_MERCHANT_COF_TYPE_RECURRING = "R";
	public static final String REQUEST_MERCHANT_COF_TYPE_REAUTHORIZATION = "H";
	public static final String REQUEST_MERCHANT_COF_TYPE_RESUBMISSION = "E";
	public static final String REQUEST_MERCHANT_COF_TYPE_DELAYED = "D";
	public static final String REQUEST_MERCHANT_COF_TYPE_INCREMENTAL = "M";
	public static final String REQUEST_MERCHANT_COF_TYPE_NOSHOW = "N";
	public static final String REQUEST_MERCHANT_COF_TYPE_OTRAS  = "C";
	
	public static final String REQUEST_MERCHANT_COF_TXNID = "DS_MERCHANT_COF_TXNID";
	
	//Request EMV3DS constants
	public static final String REQUEST_MERCHANT_EMV3DS = "DS_MERCHANT_EMV3DS";
	public static final String REQUEST_MERCHANT_EMV3DS_THREEDSINFO = "threeDSInfo"; 	
	public static final String REQUEST_MERCHANT_EMV3DS_CARDDATA = "CardData";
	public static final String REQUEST_MERCHANT_EMV3DS_AUTHENTICACIONDATA = "AuthenticationData";
	public static final String REQUEST_MERCHANT_EMV3DS_CHALLENGEREQUEST = "ChallengeRequest";
	public static final String REQUEST_MERCHANT_EMV3DS_CHALLENGEREQUESTRESPONSE = "ChallengeResponse";
	public static final String REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION = "protocolVersion";
	public static final String REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION_102 = "1.0.2";
	public static final String REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION_210 = "2.1.0";
	public static final String REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION_220 = "2.2.0";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_ACCEPT_HEADER = "browserAcceptHeader";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_ACCEPT_HEADER_VALUE = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,application/json";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_USER_AGENT = "browserUserAgent";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_USER_AGENT_VALUE = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_JAVA_ENABLE = "browserJavaEnabled";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_JAVASCRIPT_ENABLE = "browserJavascriptEnabled";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_LANGUAGE = "browserLanguage";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_COLORDEPTH = "browserColorDepth";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_SCREEN_HEIGHT = "browserScreenHeight";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_SCREEN_WIDTH = "browserScreenWidth";
	public static final String REQUEST_MERCHANT_EMV3DS_BROWSER_TZ = "browserTZ";
	public static final String REQUEST_MERCHANT_EMV3DS_THREEDSSERVERTRANSID = "threeDSServerTransID";
	public static final String REQUEST_MERCHANT_EMV3DS_NOTIFICATIONURL= "notificationURL";
	public static final String REQUEST_MERCHANT_EMV3DS_THREEDSCOMPIND = "threeDSCompInd";
	public static final String REQUEST_MERCHANT_EMV3DS_PARES = "PARes";
	public static final String REQUEST_MERCHANT_EMV3DS_MD = "MD";
	public static final String REQUEST_MERCHANT_EMV3DS_CRES = "cres";
	public static final String REQUEST_MERCHANT_EXEMPTION = "DS_MERCHANT_EXCEP_SCA";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_YES = "Y";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_LWV = "LWV";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_TRA = "TRA";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_MIT = "MIT";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_COR = "COR";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_ATD = "ATD";
	public static final String REQUEST_MERCHANT_EXEMPTION_VALUE_NDF = "NDF";
	
	

	// Response message constants
	public static final String RESPONSE_AMOUNT = "Ds_Amount";
	public static final String RESPONSE_CURRENCY = "Ds_Currency";
	public static final String RESPONSE_ORDER= "Ds_Order";
	public static final String RESPONSE_SIGNATURE= "Ds_Signature";
	public static final String RESPONSE_MERCHANT = "Ds_MerchantCode";
	public static final String RESPONSE_TERMINAL = "Ds_Terminal";
	public static final String RESPONSE_DS_RESPONSE = "Ds_Response";
	public static final String RESPONSE_AUTHORIZATION_CODE = "Ds_AuthorisationCode";
	public static final String RESPONSE_TRANSACTION_TYPE = "Ds_TransactionType";
	public static final String RESPONSE_SECURE_PAYMENT = "Ds_SecurePayment";
	public static final String RESPONSE_LANGUAGE = "Ds_Language";
	public static final String RESPONSE_MERCHANT_DATA = "Ds_MerchantData";
	public static final String RESPONSE_CARD_COUNTRY = "Ds_Card_Country";
	public static final String RESPONSE_CARD_NUMBER = "Ds_CardNumber";
	public static final String RESPONSE_EXPIRY_DATE = "Ds_ExpiryDate";
	public static final String RESPONSE_MERCHANT_IDENTIFIER = "Ds_CardNumber";
	public static final String RESPONSE_AUTHENTICATION_REQUIRED = "authenticationRequired";
	public static final String RESPONSE_AUTHENTICATION_NOT_REQUIRED = "authenticationNotRequired";
	
	
	
	// Response message DCC
	public static final String REQUEST_DS_MERCHANT_DCC = "DS_MERCHANT_DCC";
	public static final String REQUEST_DS_MERCHANT_DCC_TRUE = "Y";
	public static final String REQUEST_DS_MERCHANT_DCC_MONEDA = "monedaDCC";
	public static final String REQUEST_DS_MERCHANT_DCC_IMPORTE = "importeDCC";
	
	public static final String RESPONSE_DCC_CURRENCY_TAG = "moneda";
	public static final String RESPONSE_DCC_CURRENCY_STRING_TAG = "litMoneda";
	public static final String RESPONSE_DCC_CURRENCY_CODE_TAG = "litMonedaR";
	public static final String RESPONSE_DCC_CHANGE_RATE_TAG = "cambio";
	public static final String RESPONSE_DCC_CHANGE_DATE_TAG = "fechaCambio";
	public static final String RESPONSE_DCC_CHECKED_TAG = "checked";
	public static final String RESPONSE_DCC_AMOUNT_TAG = "importe";
	public static final String RESPONSE_DCC_MARGIN_TAG = "margenDCC";
	public static final String RESPONSE_DCC_BANK_NAME_TAG = "nombreEntidad";
		
	//Response 3DSecure
	public static final String RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION = "protocolVersion";
	public static final String RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_102 = "NO_3DS_v2";
	public static final String RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_210 = "2.1.0";
	public static final String RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_220 = "2.2.0";
	public static final String RESPONSE_PSD2_TRUE = "Y";
	public static final String RESPONSE_PSD2_FALSE = "N";
	public static final String RESPONSE_MERCHANT_EMV3DS_THREEDSMETHODURL = "threeDSMethodURL";
	public static final String RESPONSE_MERCHANT_EMV3DS_THREEDSINFO = "threeDSInfo";
	public static final String RESPONSE_MERCHANT_EMV3DS_THREEDSSERVERTRANSID = "threeDSServerTransID";
	public static final String RESPONSE_MERCHANT_EMV3DS_ACSURL = "acsURL";
	public static final String RESPONSE_MERCHANT_EMV3DS_CREQ = "creq";
	public static final String RESPONSE_MERCHANT_EMV3DS_MD = "MD";
	public static final String RESPONSE_MERCHANT_EMV3DS_PAREQ = "PAReq";
	
	// Response codes
	public static final String RESP_CODE_OK = "0";
	public static final String RESP_LITERAL_OK = "OK";
	public static final String RESP_LITERAL_KO = "KO";
	public static final String RESP_LITERAL_AUT = "AUT";


	// Result code values
	public enum ResultCode { 
		OK, KO, AUT;
		public static ResultCode isOK(boolean data) {
			if (data)
				return OK;
			else
				return KO;
		}
	}
	

	//Type of operation request
	public enum Operation {
		TRATAPETICION_REQUEST, INICIAPETICION_REQUEST;	
	}
	
	// Environment values
	public enum Environment {
		SANDBOX, PRODUCTION, CUSTOM;
		public static String getEnvironmentEndpoint(Environment env, Operation operation){
				String endpoint = "";
				switch (env) {
				case SANDBOX:
					switch (operation) {
						case TRATAPETICION_REQUEST: endpoint = RestUtils.getPropertyValue("sandboxEndpoint");	
						break;
						case INICIAPETICION_REQUEST: endpoint = RestUtils.getPropertyValue("sandboxEndpointInicia");
						break;
					}
				break;
				case PRODUCTION: 
					switch (operation) {
						case TRATAPETICION_REQUEST: endpoint = RestUtils.getPropertyValue("productionEndpoint");
						break;
						case INICIAPETICION_REQUEST: endpoint = RestUtils.getPropertyValue("productionEndpointInicia");
						break;
					}
				break;
				case CUSTOM:
					endpoint = RestUtils.getPropertyValue("customEndpoint");	
				break;
			}
			return endpoint;
	   }
	}
	
	//Response codes
	public enum ResponseCode {
		AUTHORIZATION_OK("0000"), CONFIRMATION_OK("0900"), REFUND_OK("0900"), CANCELLATION_OK("0400"), UNFINISHED("9998"), NULL("null");
		private String code;

		ResponseCode(String code) {
			this.code = code;
		}

		public String code() {
			return code;
		}

		public boolean isCode(String codeString) {
			return codeString != null && code.equals(codeString);
		}

		public static ResponseCode getEnum(String value) {
			for (ResponseCode v : values())
				if (v.code().equalsIgnoreCase(value))
					return v;
			return NULL;
		}

		void toResponseCode(String code) {
			this.code = code;
		}
	}

	//TransactionTypes
	public enum TransactionType {
		AUTHORIZATION("0"), PREAUTHORIZATION("1"), CONFIRMATION("2"), REFUND("3"), CANCELLATION("9"), VALIDATION("7"), VALIDATION_CONFIRMATION("8"), DELETE_REFERENCE("44"), PAYGOLD_REQUEST("F"), REFUND_WITHOUT_ORIGINAL("Y"), NULL("NULL");
		private String type;

		TransactionType(String type) {
			this.type = type;
		}

		public String type() {
			return type;
		}

		public static TransactionType getEnum(String value) {
			for (TransactionType v : values())
				if (v.type().equalsIgnoreCase(value))
					return v;
			return NULL;
		}
	}
	

}

