package es.redsys.rest.api.model.element;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import es.redsys.rest.api.constants.RestConstants;

public class RestOperationElement {
	@JsonProperty("Ds_Amount")
	private String amount;
	
	@JsonProperty("Ds_Currency")
	private String currency;
	
	@JsonProperty("Ds_Order")
	private String order;
	
	@JsonProperty("Ds_Signature")
	private String signature;	
	
	@JsonProperty("Ds_MerchantCode")
	private String merchant;
	
	@JsonProperty("Ds_Terminal")
	private String terminal;
	
	@JsonProperty("Ds_Response")
	private String responseCode;
	
	@JsonProperty("Ds_AuthorisationCode")
	private String authCode;
	
	@JsonProperty("Ds_TransactionType")
	private String transactionType;
	
	@JsonProperty("Ds_SecurePayment")
	private String securePayment;
	
	@JsonProperty("Ds_Language")
	private String language;
	
	@JsonProperty("Ds_MerchantData")
	private String merchantData;
	
	@JsonProperty("Ds_Card_Country")
	private String cardCountry;
	
	@JsonProperty("Ds_CardNumber")
	private String cardNumber;
	
	@JsonProperty("Ds_Card_Brand")
	private String cardBrand;
	
	@JsonProperty("Ds_Card_Type")
	private String cardType;
	
	@JsonProperty("Ds_ExpiryDate")
	private String expiryDate;
	
	@JsonProperty("Ds_Merchant_Identifier")
	private String merchantIdentifier;
	
	@JsonProperty("Ds_Card_PSD2")
	private String psd2;
	
	@JsonProperty("Ds_Excep_SCA")
	private String exemption;
	
	@JsonProperty("Ds_Merchant_Cof_Txnid")
	private String cofTxnid;

	@JsonProperty("Ds_EMV3DS")
	private Map<String, String> emv;
	
	@JsonProperty("Ds_DCC")
	private Map<String, Map<String, String>> dcc;
	
	@JsonProperty("InfoMonedaTarjeta")
	private Map<String, String> infoMonedaTarjeta;
	
	@JsonProperty("Ds_ProcessedPayMethod")
	private String processedPayMethod;
	
	//EMV3DS
	private String acsURL = "";
	private String protocolVersion;
	private String threeDSInfo;
	
	
	public String getAmount() {
		return amount;
	}
	public void setAmount(String amount) {
		this.amount = amount;
	}
	public String getAuthCode() {
		return authCode;
	}
	public void setAuthCode(String authCode) {
		this.authCode = authCode;
	}
	public String getCardCountry() {
		return cardCountry;
	}
	public void setCardCountry(String cardCountry) {
		this.cardCountry = cardCountry;
	}
	public String getCardNumber() {
		return cardNumber;
	}
	public void setCardNumber(String cardNumber) {
		this.cardNumber = cardNumber;
	}
	public String getCardBrand() {
		return cardBrand;
	}
	public void setCardBrand(String cardBrand) {
		this.cardBrand = cardBrand;
	}
	public String getCardType() {
		return cardType;
	}
	public void setCardType(String cardType) {
		this.cardType = cardType;
	}
	public String getCurrency() {
		return currency;
	}
	public void setCurrency(String currency) {
		this.currency = currency;
	}
	public String getLanguage() {
		return language;
	}
	public void setLanguage(String language) {
		this.language = language;
	}
	public String getMerchant() {
		return merchant;
	}
	public void setMerchant(String merchant) {
		this.merchant = merchant;
	}
	public String getMerchantData() {
		return merchantData;
	}
	public void setMerchantData(String merchantData) {
		this.merchantData = merchantData;
	}
	public String getOrder() {
		return order;
	}
	public void setOrder(String order) {
		this.order = order;
	}
	public String getResponseCode() {
		return responseCode;
	}
	public void setResponseCode(String responseCode) {
		this.responseCode = responseCode;
	}
	public String getSecurePayment() {
		return securePayment;
	}
	public void setSecurePayment(String securePayment) {
		this.securePayment = securePayment;
	}
	public String getTerminal() {
		return terminal;
	}
	public void setTerminal(String terminal) {
		this.terminal = terminal;
	}
	public String getTransactionType() {
		return transactionType;
	}
	public void setTransactionType(String transactionType) {
		this.transactionType = transactionType;
	}
	public String getExpiryDate() {
		return expiryDate;
	}
	public void setExpiryDate(String expiryDate) {
		this.expiryDate = expiryDate;
	}
	public String getMerchantIdentifier() {
		return merchantIdentifier;
	}
	public void setMerchantIdentifier(String merchantIdentifier) {
		this.merchantIdentifier = merchantIdentifier;
	}
	
	
	public String getThreeDSInfo() {
		return threeDSInfo;
	}
	public void setThreeDSInfo(String threeDSInfo) {
		this.threeDSInfo = threeDSInfo;
	}
	public String getProtocolVersion() {
		return protocolVersion;
	}
	public void setProtocolVersion(String protocolVersion) {
		this.protocolVersion = protocolVersion;
	}
	public String getSignature() {
		return signature;
	}
	public void setSignature(String signature) {
		this.signature = signature;
	}
	public Map<String, String> getEmv() {
		return emv;
	}
	public String getPsd2() {
		return psd2;
	}
	public void setPsd2(String psd2) {
		this.psd2 = psd2;
	}
	public String getExemption() {
		return exemption;
	}
	public void setExemption(String exemption) {
		this.exemption = exemption;
	}

	 public String getCofTxnid() {
		return cofTxnid;
	}
	public void setCofTxnid(String cofTxnid) {
		this.cofTxnid = cofTxnid;
	}

	public Map<String, Map<String, String>> getDcc() {
		return dcc;
	}
	public void setDcc(Map<String, Map<String, String>> dcc) {
		this.dcc = dcc;
	}
	public Map<String, String> getInfoMonedaTarjeta() {
		return infoMonedaTarjeta;
	}
	public void setInfoMonedaTarjeta(Map<String, String> infoMonedaTarjeta) {
		this.infoMonedaTarjeta = infoMonedaTarjeta;
	}
	/** Method to get the PSD2 result value (inform us if authentication is mandatory)
	 * @return psd2: informa if authenticacion its mandatory (Y/N)
	 */
	public Boolean isPSD2() {
		boolean required = false;
		try {
			String psd2 = getPsd2();
			if (RestConstants.RESPONSE_PSD2_TRUE.equals(psd2)) {
				required = true;
			}
		} catch (Exception e) {
		}
		
		return required;
	}
	
	/** Method that inform if neeeds authentication
	 * @param acsURL: authenticacion URL, if needs authentication, the virtual TPV return the authentication URL
	 */
	public Boolean requiresSCA() {
		boolean required = false;
		try {
			String acsURL = getEmv().get("acsURL");
			if (acsURL.length() > 10) {
				required = true;
			}
		} catch (Exception e) {
		}
		return required;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("InsiteOperationElement [amount=");
		builder.append(amount);
		builder.append(", currency=");
		builder.append(currency);
		builder.append(", order=");
		builder.append(order);
		builder.append(", signature=");
		builder.append(signature);
		builder.append(", merchant=");
		builder.append(merchant);
		builder.append(", terminal=");
		builder.append(terminal);
		builder.append(", responseCode=");
		builder.append(responseCode);
		builder.append(", authCode=");
		builder.append(authCode);
		builder.append(", transactionType=");
		builder.append(transactionType);
		builder.append(", securePayment=");
		builder.append(securePayment);
		builder.append(", language=");
		builder.append(language);
		builder.append(", merchantData=");
		builder.append(merchantData);
		builder.append(", cardCountry=");
		builder.append(cardCountry);
		builder.append(", cardNumber=");
		builder.append(cardNumber);
		builder.append(", expiryDate=");
		builder.append(expiryDate);
		builder.append(", merchantIdentifier=");
		builder.append(merchantIdentifier);
		builder.append(", DCC=");
		builder.append(dcc);
		builder.append(", emv=");
		builder.append(emv);
		builder.append("]");
		return builder.toString();
	}

	
}
