package es.redsys.rest.test.example;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;

import es.redsys.rest.api.constants.RestConstants.Environment;
import es.redsys.rest.api.constants.RestConstants.Operation;
import es.redsys.rest.api.constants.RestConstants.TransactionType;
import es.redsys.rest.api.model.RestResponse;
import es.redsys.rest.api.model.message.RestOperationMessage;
import es.redsys.rest.api.service.RestService;
import es.redsys.rest.api.service.impl.RestOperationService;

/** 
 * Los ejemplos proporcionados en el API son una representación de como utilizar 
 * las diferentes funciones del API y no se deben utilizar tal cual se proporcionan,
 * ya que no contienen validaciones de seguridad y de negocio propias de la 
 * implementación de cada comercio. Redsys no se hace responsable de la utilización
 * de estos ejemplos en el servidor del comercio tal cual se proporcionan. 
 * 
 * 
 * The examples provided in the API are a representation of how to use
 * the different API functions and should not be used as provided,
 * since they do not contain security and business validations typical of the
 * implementation of each trade. Redsys is not responsible for the use
 * of these examples on the merchant's server as provided.
 */

/**
 * Example Class for testing purposes
 * @author Redsys
 */

public class ExampleDirectPaymentCardData {

	/**
	 * Method for random order number
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	public static String randomOrderID() {
		StringBuilder orderID = new StringBuilder();
		for(int i = 0 ; i < 10 ; ++i) {
			orderID.append(ALPHA_NUMERIC_STRING.charAt(ThreadLocalRandom.current().nextInt(ALPHA_NUMERIC_STRING.length())));
		}
		
		return orderID.toString();
	}
	
	
	/**
	 * Main method for testing purposes
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	public static void main(String [] args) throws IOException {
		directPaymentOperation();
	}

	
	/**
	 * Example method for a directPayment Request
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	private static void directPaymentOperation() {
		
		String orderID=randomOrderID();
		RestOperationMessage request = new RestOperationMessage();
		// Operation mandatory data
		request.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		request.setCurrency("978"); // ISO-4217 numeric currency code
		request.setMerchant("999008881");
		request.setTerminal("20");
		request.setOrder(orderID);
		request.setTransactionType(TransactionType.AUTHORIZATION);
		//CardData information
		request.setCardNumber("4548810000000003");
		request.setCardExpiryDate("3412");
		request.setCvv2("123");
		
		// Other optional parameters example can be added by "addParameter" method
		request.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago con directPayment y tarjeta");
		
		//Method for a direct payment request (without authentication)
		request.useDirectPayment();
		
		// Response object
		RestResponse response = null;
		try {
			// Service setting (Signature, Environment, type of payment)
			RestService service = new RestOperationService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
			response = service.sendOperation(request);
			// Response analysis
			System.out.println(response.toString());
			switch (response.getResult()) {
				case OK: System.out.println("Operation was OK"); break;
				case AUT: System.out.println("Operation requires authentication"); break;
				default: System.out.println("Operation was not OK"); break;
			}
		} catch (Exception e) {
			// Error treatment
			e.printStackTrace();
		}
	}
	
}