package es.redsys.rest.api.model.message;

import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonProperty;

import es.redsys.rest.api.constants.RestConstants;
import es.redsys.rest.api.constants.RestConstants.ResultCode;
import es.redsys.rest.api.constants.RestConstants.TransactionType;
import es.redsys.rest.api.model.RestResponse;
import es.redsys.rest.api.model.element.RestOperationElement;

public class RestResponseMessage implements RestResponse {
	
	private ResultCode result;
	private String apiCode;
	private RestOperationElement operation;
	
	public ResultCode getResult() {
		return result;
	}
	public void setResult(ResultCode result) {
		this.result= result;
	}
	public String getApiCode() {
		return apiCode;
	}
	public void setApiCode(String code) {
		this.apiCode = code;
	}
	public RestOperationElement getOperation() {
		return operation;
	}
	public void setOperation(RestOperationElement operation) {
		this.operation = operation;
	}
	
	public TransactionType getTransactionType() {
		if (null != getOperation()) {
			return TransactionType.getEnum(getOperation().getTransactionType());
		} else {
			return null;
		}
	}

	/** 
	 * Method to get the protocolVersion
	 * @return protocolVersion: 3EMV3DS authentications version
	 */	
	@Override
	public String protocolVersionAnalysis() {
		//To get protocolVersion 
		//InsiteResponseMessage res = (InsiteResponseMessage) response;
		String version3DSecure = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION);
		//Protocol Version analysis
		if (RestConstants.RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_102.equals(version3DSecure)) {
			version3DSecure = "1.0.2";
			System.out.println("ProtocolVersion 1.0.2");
		}else if (RestConstants.RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_210.equals(version3DSecure)) {
			System.out.println("ProtocolVersion 2.1.0");
		} else if (RestConstants.RESPONSE_MERCHANT_EMV3DS_PROTOCOLVERSION_220.equals(version3DSecure)) {
			System.out.println("ProtocolVersion 2.2.0");
		}
		
		return version3DSecure;
	}
	
	/** 
	 * Method to get the PSD2 result value (inform us if authentication is mandatory)
	 * @return psd2: informa if authenticacion its mandatory (Y/N)
	 */	
	@Override
	public String PSD2analysis() {			
		return getOperation().getPsd2();
	}
	
	/** 
	 * Method to get the Exemption result value
	 * @return Ds_Excep_SCA: exemption allowed to the commerce
	 */	
	@Override
	public String getExemption() {			
		return getOperation().getExemption();
	}
	
	/** 
	 * Method to get Ds_Merchant_Cof_Txnid
	 * @return param
	 */	
	@Override
	public String getCOFTxnid() {			
		return getOperation().getCofTxnid();
	}
	
	
	/** 
	 * Method to get the MD parameter value (protocolVersion 1.0.2)
	 * @return md: protocolVersion 1.0.2 authentication parameter
	 */	
	@Override
	public String getMDParameter() {
		String md = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_MD);
		
	return md;
	}
		
	/** 
	 * Method to get the ACSURL parameter value (protocolVersion 1.0.2)
	 * @return AcsURL: protocolVersion 1.0.2 authentication URL
	 */	
	@Override
	public String getAcsURLParameter() {
		String acsURL = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_ACSURL);
	return acsURL;
	}
	
	/** 
	 * Method to get the DCC Currency
	 * @return dccCurrency: DCC initialRequest Currency
	 */	
	@Override
	public String getDCCCurrency() {
		String dccCurrency = getOperation().getDcc().get("InfoMonedaTarjeta").get("monedaDCC").toString();
		System.out.println("EL CURRENCY: " + dccCurrency);		
	return dccCurrency;
	}
	
	/** 
	 * Method to get the DCC amount
	 * @return dccAmount: DCC initialRequest amount
	 */	
	@Override
	public String getDCCAmount() {
		String dccAmount = getOperation().getDcc().get("InfoMonedaTarjeta").get("importeDCC").toString();
		System.out.println("EL AMOUNT: " + dccAmount);		
	return dccAmount;
	}
		
	/** 
	 * Method to get the PAREQ parameter value (protocolVersion 1.0.2)
	 * @return protocolVersion 1.0.2 authentication parameter
	 */	
	@Override
	public String getPAReqParameter() {
		String pAReq = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_PAREQ);
	return pAReq;
	}
		
	/** 
	 * Method to get the threeDSServerTransID parameter value (protocolVersion 2.X.0)
	 * @return protocolVersion 2.X.0 authentication parameter
	 */	
	@Override
	public String getThreeDSServerTransID() {
		String threeDSServerTransID = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_THREEDSSERVERTRANSID);
	return threeDSServerTransID;
	}
		
	/** 
	 * Method to get the threeDSInfo parameter value
	 * @return Authentication parameter Info for each operation
	 */	
	@Override
	public String getThreeDSInfo() {
		String threeDSInfo = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_THREEDSINFO);
	return threeDSInfo;
	}

		
	/** 
	 * Method to get the threeDSMethodURL parameter value (protocolVersion 2.X.0)
	 * @return protocolVersion 2.X.0 authentication URL
	 */	
	@Override
	public String getThreeDSMethodURL() {
		String threeDSMethod = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_THREEDSMETHODURL);
	return threeDSMethod;
	}
		
		
	/** 
	 * Method to get the CREQ parameter value (protocolVersion 2.X.0)
	 * @return protocolVersion 2.X.0 authentication parameter
	 */	
	@Override
	public String getCreqParameter() {
		String creq = getOperation().getEmv().get(RestConstants.RESPONSE_MERCHANT_EMV3DS_CREQ);
		return creq;
	}
		
		@Override
		public String toString() {
			StringBuilder builder = new StringBuilder();
			builder.append("InsiteResponseMessage [result=");
			builder.append(result);
			builder.append(", apiCode=");
			builder.append(apiCode);
			builder.append(", operation=");
			builder.append(operation);
			builder.append("]");
			return builder.toString();
		}

}
