package es.redsys.rest.api.model.message;

import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonProperty;

import es.redsys.rest.api.constants.RestConstants;
import es.redsys.rest.api.constants.RestConstants.TransactionType;
import es.redsys.rest.api.model.RestRequest;
import es.redsys.rest.api.utils.RestTransformUtils;

public class RestAuthenticationRequestMessage implements RestRequest {

		
	/** Merchant code (FUC) */
	private String merchant;
	
	/** Terminal code */
	private String terminal;
	
	/** Operation order code */
	private String order;
	
	/** Operation ID code */
	private String operID;
	
	/** Operation type */
	private TransactionType transactionType;
	
	/** Currency code (ISO 4217)
	 * @see https://en.wikipedia.org/wiki/ISO_4217 */
	private String currency;
	
	/** Operation amount, without decimal separation */
	private String amount;
	
	/** Card Number */
	private String cardNumber;
	
	/** Card ExpiryDate */
	private String cardExpiryDate;
	
	/** Card CVV2 */
	private String cvv2;
	
	/** Other operation parameters */
	private Map<String, String> parameters;

	/** 3DSecure information */
	private Map<String, String> emv;
	
	
	//Getters and setters
	/** gets the amount of the operation
	 * @return the operation amount
	 */
	public String getAmount() {
		return amount;
	}

	/** sets the amount of the operation
	 * @param amount without decimal separation
	 */
	public void setAmount(String amount) {
		this.amount = amount;
	}

	/** get currency code
	 * @return the currency code (numeric ISO_4217)
	 */
	public String getCurrency() {
		return currency;
	}

	/** sets the currency code
	 * @param currency the currency code (numeric ISO_4217 )
	 */
	public void setCurrency(String currency) {
		this.currency = currency;
	}

	/** gets the merchant code (FUC)
	 * @return the merchant code
	 */
	public String getMerchant() {
		return merchant;
	}

	/** sets the merchant code
	 * @param merchant merchant code
	 */
	public void setMerchant(String merchant) {
		this.merchant = merchant;
	}

	/** gets the operation ID
	 * @return the operation ID
	 */
	public String getOperID() {
		return operID;
	}

	/** sets the operation ID
	 * @param operID the operation ID
	 */
	public void setOperID(String operID) {
		this.operID = operID;
	}

	/** gets the operation order code (max length 12)
	 * @return the operation order (max length 12)
	 */
	public String getOrder() {
		return order;
	}

	/** sets the operation order (max length 12)
	 * @param order (max length 12)
	 */
	public void setOrder(String order) {
		this.order = order;
	}

	/** gets the terminal code
	 * @return the terminal code
	 */
	public String getTerminal() {
		return terminal;
	}

	/** sets the terminal code
	 * @param terminal terminal code (max lenght 3)
	 */
	public void setTerminal(String terminal) {
		this.terminal = terminal;
	}

	/** gets the operation type 
	 * @return the operation type
	 */
	public TransactionType getTransactionType() {
		return transactionType;
	}

	/**
	 * @return the cardNumber
	 */
	public String getCardNumber() {
		return cardNumber;
	}

	/**
	 * @param cardNumber the cardNumber to set
	 */
	public void setCardNumber(String cardNumber) {
		this.cardNumber = cardNumber;
	}

	/**
	 * @return the cardExpiryDate
	 */
	public String getCardExpiryDate() {
		return cardExpiryDate;
	}

	/**
	 * @param cardExpiryDate the cardExpiryDate to set
	 */
	public void setCardExpiryDate(String cardExpiryDate) {
		this.cardExpiryDate = cardExpiryDate;
	}

	/**
	 * @return the cvv2
	 */
	public String getCvv2() {
		return cvv2;
	}

	/**
	 * @param cvv2 the cvv2 to set
	 */
	public void setCvv2(String cvv2) {
		this.cvv2 = cvv2;
	}

	/** sets the operation type
	 * @param transactionType the operation type
	 */
	public void setTransactionType(TransactionType transactionType) {
		this.transactionType = transactionType;
	}

	/** gets the 3DSecure Information
	 * @return 3DSecure Information
	 */
	public Map<String, String> getEmv() {
		return emv;
	}

	/** sets the 3DSecure Request Info
	 *@param 3DSecure param
	 *@param 3DSecure value
	 */
	public void setEmv(Map<String, String> emv) {
		this.emv = emv;
	}
	
	/** sets the 3DSecure Request Info
	 *@param 3DSecure param and value
	 */
	public void setEmv(String emv) {
		this.emv = RestTransformUtils.JSONToMap(emv);
	}
	
	//Methods
	
	/** Flag for reference creation (card token for merchant to use in other operations) */
	public void createReference() {
		addParameter(RestConstants.REQUEST_MERCHANT_IDENTIFIER, RestConstants.REQUEST_MERCHANT_IDENTIFIER_REQUIRED);
	}
	
	/** Method for using a reference created before for the operation
	 * @param reference the reference string to be used
	 */
	public void useReference(String reference) {
		addParameter(RestConstants.REQUEST_MERCHANT_IDENTIFIER, reference);
		
	}
	
	/** 
	 * Method for the first COF operation
	 */	
	public void setCOFOperation(String cofType) {
		
		addParameter(RestConstants.REQUEST_MERCHANT_COF_INI, RestConstants.REQUEST_MERCHANT_COF_INI_TRUE);
		addParameter(RestConstants.REQUEST_MERCHANT_COF_TYPE, cofType);
	}
	
	/** 
	 * Method for a COF operation
	 */	
	public void setCOFTxnid(String txnid) {
		addParameter(RestConstants.REQUEST_MERCHANT_COF_TXNID, txnid);
	}
	
	/** Other optional operation parameters 
	 * @param key key parameter
	 * @param value key value 
	 */
	public void addParameter(String key, String value) {
		if (null == parameters) {
			parameters = new HashMap<String, String>();
		}
		parameters.put(key, value);
	}

	/** returns every parameter
	 * @return the parameter map
	 */
	public Map<String, String> getParameters() {
		return this.parameters;
	}
	
	/** Other optional operation parameters 
	 * @param key key parameter
	 * @param value key value 
	 */
	public void addEmvParameter(String key, String value) {
		if (null == emv) {
			emv = new HashMap<String, String>();
		}
		emv.put(key, value);
	}
	
	/** 
	 * demand DCC card info in the response 
	 */
	public void demandDccinfo() {
		addParameter(RestConstants.REQUEST_DS_MERCHANT_DCC, RestConstants.REQUEST_DS_MERCHANT_DCC_TRUE);
	}
	
	/** 
	 * Method for set the EMV3DS return parameters for a V1 challenge Request 
	 * @param pares protocolVersion 1.0.2 authentication parameter
	 * @param md protocolVersion 1.0.2 authentication parameter
	 */	
	public void challengeRequestV1(String pares, String md) {
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_THREEDSINFO, RestConstants.REQUEST_MERCHANT_EMV3DS_CHALLENGEREQUESTRESPONSE);
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION, RestConstants.REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION_102);
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_PARES, pares);
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_MD, md);
	}
	
	
	/** 
	 * Method for set the EMV3DS return parameters for a V2 challenge Request 
	 * @param protocolVersion protocolVersion 2.X.0 authentication parameter 
	 * @param cres protocolVersion 2.X.0 authentication parameter
	 */	
	public void challengeRequestV2(String protocolVersion, String cres) {
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_THREEDSINFO, RestConstants.REQUEST_MERCHANT_EMV3DS_CHALLENGEREQUESTRESPONSE);
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_PROTOCOLVERSION, protocolVersion);
		addEmvParameter(RestConstants.REQUEST_MERCHANT_EMV3DS_CRES, cres);
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append(", order=");
		builder.append(order);
		builder.append(", amount=");
		builder.append(amount);
		builder.append(", currency=");
		builder.append(currency);
		builder.append(", merchant=");
		builder.append(merchant);
		builder.append(", terminal=");
		builder.append(terminal);
		builder.append(", transactionType=");
		builder.append(transactionType);
		builder.append(", emv=");
		builder.append(getEmv());
		builder.append("]");
		return builder.toString();
	}


}
